/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.integration.energy;

import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import sonar.fluxnetworks.api.energy.IBlockEnergyBridge;
import sonar.fluxnetworks.api.energy.IItemEnergyBridge;
import sonar.fluxnetworks.common.util.FluxUtils;

public class ForgeEnergyBridge
implements IBlockEnergyBridge,
IItemEnergyBridge {
    public static final ForgeEnergyBridge INSTANCE = new ForgeEnergyBridge();

    private ForgeEnergyBridge() {
    }

    @Override
    public boolean hasCapability(@Nonnull BlockEntity target, @Nonnull Direction side) {
        return !target.m_58901_() && target.getCapability(CapabilityEnergy.ENERGY, side).isPresent();
    }

    @Override
    public boolean canAddEnergy(@Nonnull BlockEntity target, @Nonnull Direction side) {
        IEnergyStorage storage;
        if (!target.m_58901_() && (storage = (IEnergyStorage)FluxUtils.get((ICapabilityProvider)target, CapabilityEnergy.ENERGY, side)) != null) {
            return storage.canReceive();
        }
        return false;
    }

    @Override
    public boolean canRemoveEnergy(@Nonnull BlockEntity target, @Nonnull Direction side) {
        IEnergyStorage storage;
        if (!target.m_58901_() && (storage = (IEnergyStorage)FluxUtils.get((ICapabilityProvider)target, CapabilityEnergy.ENERGY, side)) != null) {
            return storage.canExtract();
        }
        return false;
    }

    @Override
    public long addEnergy(long amount, @Nonnull BlockEntity target, @Nonnull Direction side, boolean simulate) {
        IEnergyStorage storage = (IEnergyStorage)FluxUtils.get((ICapabilityProvider)target, CapabilityEnergy.ENERGY, side);
        return storage == null ? 0L : (long)storage.receiveEnergy((int)Math.min(amount, Integer.MAX_VALUE), simulate);
    }

    @Override
    public long removeEnergy(long amount, @Nonnull BlockEntity target, @Nonnull Direction side, boolean simulate) {
        IEnergyStorage storage = (IEnergyStorage)FluxUtils.get((ICapabilityProvider)target, CapabilityEnergy.ENERGY, side);
        return storage == null ? 0L : (long)storage.extractEnergy((int)Math.min(amount, Integer.MAX_VALUE), simulate);
    }

    @Override
    public boolean hasCapability(@Nonnull ItemStack stack) {
        return stack.getCapability(CapabilityEnergy.ENERGY).isPresent();
    }

    @Override
    public boolean canAddEnergy(@Nonnull ItemStack stack) {
        IEnergyStorage storage = (IEnergyStorage)FluxUtils.get((ICapabilityProvider)stack, CapabilityEnergy.ENERGY);
        return storage != null && storage.canReceive();
    }

    @Override
    public boolean canRemoveEnergy(@Nonnull ItemStack stack) {
        IEnergyStorage storage = (IEnergyStorage)FluxUtils.get((ICapabilityProvider)stack, CapabilityEnergy.ENERGY);
        return storage != null && storage.canExtract();
    }

    @Override
    public long addEnergy(long amount, @Nonnull ItemStack stack, boolean simulate) {
        IEnergyStorage storage = (IEnergyStorage)FluxUtils.get((ICapabilityProvider)stack, CapabilityEnergy.ENERGY);
        return storage == null ? 0L : (long)storage.receiveEnergy((int)Math.min(amount, Integer.MAX_VALUE), simulate);
    }

    @Override
    public long removeEnergy(long amount, @Nonnull ItemStack stack, boolean simulate) {
        IEnergyStorage storage = (IEnergyStorage)FluxUtils.get((ICapabilityProvider)stack, CapabilityEnergy.ENERGY);
        return storage == null ? 0L : (long)storage.extractEnergy((int)Math.min(amount, Integer.MAX_VALUE), simulate);
    }
}

